package skotty

import (
	"crypto/md5"
	"encoding/hex"
	"fmt"
)

func SerialToTokenID(tokenType TokenType, serial string) (string, error) {
	md5Hex := func(string) string {
		h := md5.New()
		h.Write([]byte(serial))
		return hex.EncodeToString(h.Sum(nil))
	}

	switch tokenType {
	case TokenTypeSoft:
		return "s" + md5Hex(serial), nil
	case TokenTypeMemory:
		return "m" + md5Hex(serial), nil
	case TokenTypeRoboMemory:
		return "r" + serial, nil
	case TokenTypeYubikey:
		return "y" + serial, nil
	default:
		return "", fmt.Errorf("unsupported token type: %s", tokenType)
	}
}
