package skotty

import (
	"encoding/json"
	"fmt"
)

var _ json.Marshaler = (*TokenType)(nil)
var _ json.Unmarshaler = (*TokenType)(nil)

type TokenType uint8

const (
	TokenTypeNone TokenType = iota
	TokenTypeYubikey
	TokenTypeSoft
	TokenTypeMemory
	TokenTypeRoboMemory
)

func (t TokenType) String() string {
	switch t {
	case TokenTypeYubikey:
		return "yubikey"
	case TokenTypeSoft:
		return "soft"
	case TokenTypeMemory:
		return "memory"
	case TokenTypeRoboMemory:
		return "robo-memory"
	case TokenTypeNone:
		return "none"
	default:
		return fmt.Sprintf("unknown %d", t)
	}
}

func (t TokenType) MarshalJSON() ([]byte, error) {
	return json.Marshal(t.String())
}

func (t *TokenType) UnmarshalJSON(in []byte) error {
	var val string
	if err := json.Unmarshal(in, &val); err != nil {
		return err
	}

	switch val {
	case "yubikey":
		*t = TokenTypeYubikey
	case "soft":
		*t = TokenTypeSoft
	case "memory":
		*t = TokenTypeMemory
	case "robo-memory":
		*t = TokenTypeRoboMemory
	case "none":
		*t = TokenTypeNone
	default:
		return fmt.Errorf("unknown token type: %s", val)
	}

	return nil
}
