package skottyca

import (
	"time"

	"a.yandex-team.ru/library/go/core/log"
)

const (
	DefaultSyncPeriod = 30 * time.Minute
)

const (
	CAKindInsecure = "insecure"
	CAKindSecure   = "secure"
)

type Option func(ca *SkottyCA)

func WithLogger(l log.Logger) Option {
	return func(ca *SkottyCA) {
		ca.l = l
	}
}

func WithKind(kinds ...string) Option {
	return func(ca *SkottyCA) {
		ca.caKinds = kinds
	}
}

func WithSyncPeriod(d time.Duration) Option {
	return func(ca *SkottyCA) {
		ca.syncPeriod = d
	}
}
