package main

import (
	"errors"
	"fmt"
	"unsafe"
)

/*
#cgo LDFLAGS: -lpam -fPIC
#include <security/pam_appl.h>
#include <stdlib.h>

char *string_from_argv(int, char**);
int get_uid(char *user);
*/
import "C"

func sliceFromArgv(argc C.int, argv **C.char) []string {
	r := make([]string, 0, argc)
	for i := 0; i < int(argc); i++ {
		s := C.string_from_argv(C.int(i), argv)
		r = append(r, C.GoString(s))
		C.free(unsafe.Pointer(s))
	}
	return r
}

func returnPamError(err error) C.int {
	var pamErr *PamError
	if errors.As(err, &pamErr) {
		pamLog(pamErr.Msg)
		if pamErr.RetCode != 0 {
			return C.int(pamErr.RetCode)
		}
	}

	return C.PAM_AUTH_ERR
}

//export pam_sm_authenticate
func pam_sm_authenticate(pamh *C.pam_handle_t, flags, argc C.int, argv **C.char) C.int {
	ph, err := NewPamHandle(pamh)
	if err != nil {
		return returnPamError(err)
	}

	err = pamAuthenticate(ph, sliceFromArgv(argc, argv))
	if err != nil {
		msg := fmt.Sprintf("skotty authentication failed: %v\n", err)
		pamLog(msg)
		_ = ph.PrintError(msg)
		return C.PAM_AUTH_ERR
	}

	return C.PAM_SUCCESS
}

//export pam_sm_setcred
func pam_sm_setcred(pamh *C.pam_handle_t, flags, argc C.int, argv **C.char) C.int {
	return C.PAM_IGNORE
}
