package main

import (
	"errors"
	"fmt"
	"os"
	"strconv"
	"syscall"
)

func doKill() error {
	rawPID, ok := os.LookupEnv("SSH_AGENT_PID")
	if !ok {
		return errors.New("SSH_AGENT_PID not set")
	}

	pid, err := strconv.Atoi(rawPID)
	if err != nil {
		return fmt.Errorf("SSH_AGENT_PID=%s, which is not a good PID: %w", rawPID, err)
	}

	if err := syscall.Kill(-pid, syscall.SIGTERM); err != nil {
		return fmt.Errorf("send SIGTERM signal to the PID %d: %w", pid, err)
	}

	fmt.Println("unset SSH_AUTH_SOCK;")
	fmt.Println("unset SSH_AGENT_PID;")
	fmt.Printf("echo Agent pid %d killed;\n", pid)
	return nil
}
