package agent

import (
	"fmt"
	"os"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/skotty/libs/netutil"
)

func credLogFields(creds *netutil.UnixCreds) []log.Field {
	return []log.Field{
		log.Int("c_pid", creds.PID),
		log.Int("c_uid", creds.UID),
	}
}

func checkCreds(creds *netutil.UnixCreds) error {
	uid := os.Getuid()
	if creds.UID != 0 && creds.UID != uid {
		return fmt.Errorf("connection from another user (except root) is prohibited: %d (connection) != %d (expected)", creds.UID, uid)
	}

	return nil
}
