package issuer

import "a.yandex-team.ru/security/skotty/libs/skotty"

type SkottyIssuerOption func(*SkottyIssuer)

func WithSkottyRoboClient(c *skotty.RoboClient) SkottyIssuerOption {
	return func(issuer *SkottyIssuer) {
		issuer.roboc = c
	}
}

func WithCertType(typ ...skotty.CertType) SkottyIssuerOption {
	return func(issuer *SkottyIssuer) {
		issuer.certTypes = typ
	}
}
