package sshutil

import (
	"bytes"
	"strconv"
)

func SSHAgentScript(socketPath string, pid int) []byte {
	out := bytes.NewBuffer(nil)
	out.WriteString("SSH_AUTH_SOCK=")
	out.WriteString(socketPath)
	out.WriteString("; export SSH_AUTH_SOCK;\n")

	out.WriteString("SSH_AGENT_PID=")
	out.WriteString(strconv.Itoa(pid))
	out.WriteString("; export SSH_AGENT_PID;\n")

	out.WriteString("echo Agent pid ")
	out.WriteString(strconv.Itoa(pid))
	out.WriteByte(';')
	out.WriteByte('\n')

	return out.Bytes()
}
