package syncer

import (
	"fmt"
	"strings"
)

type KeyID struct {
	Provider string
	CertType string
	Serial   string
	EnrollID string
}

func ParseKeyID(s string) (KeyID, error) {
	parts := strings.Split(s, ":")
	if len(parts) < 4 {
		return KeyID{}, fmt.Errorf("invalid keyid format: %s", s)
	}

	return KeyID{
		Provider: parts[0],
		CertType: parts[1],
		Serial:   parts[2],
		EnrollID: parts[3],
	}, nil
}
