package version

import (
	"fmt"
	"io"

	"a.yandex-team.ru/library/go/core/buildinfo"
)

const majorMinorVer = "0.9"

func Full() string {
	patch := buildinfo.Info.ArcadiaSourceRevision
	if patch == "" || patch == "-1" {
		patch = "0"
	}

	return fmt.Sprintf("%s.%s", majorMinorVer, patch)
}

func WriteFullInfo(out io.Writer) {
	_, _ = fmt.Fprintf(out, "Version: %s\n", Full())
	_, _ = fmt.Fprintln(out, buildinfo.Info.ProgramVersion)
}
