import {CoreConfig, AuthPolicy} from '@yandex-data-ui/core/build/types';
import envConfig from './env';

interface SkottyConfig {
    tgChat: string;
}

declare type Config = CoreConfig & SkottyConfig;

const config: Config = {
    csp: 'disabled',
    appTitle: 'Skotty',
    tgChat: 'https://t.me/+ga7UEj4gQ4JkZWUy',
    port: envConfig.port,
    socket: envConfig.socket,
    authPolicy: AuthPolicy.optional,
    tvmSelfId: envConfig.tvmSelfId,
    tvmDestinations: envConfig.tvmDestinations,
    bodyParserRaw: {
        type: 'multipart/form-data',
        limit: '21mb',
    },
    passport: {
        blackbox: {
            api: envConfig.blackboxHost,
            multisession: 'yes',
            // @ts-ignore
            timeout: 1000,
            attributes: {},
            retries: 2,
        },
        resignPath: envConfig.resignPath,
    },
    loggingLevel: envConfig.loggingLevel ||  'debug',
    csrf: {
        headerName: 'X-CSRF-Token',
        secret: process.env.CSRF_SECRET || 'kek',
    },
};

export default config;
