import {Request, Response} from '@yandex-data-ui/core/build/types';
import {createTicketInternal, uploadTrackerFileInternal} from '@yandex-data-ui/support-controller';

export default async function (req: Request, res: Response) {
    const {action} = req.params;

    switch (action) {
        case 'create-ticket': {
            const {description, meta, summary, attachmentIds} = req.body;

            return createTicketInternal({
                queue: 'SKOTTY',
                trackerTags: ['report'],
                meta,
                summary,
                description,
                attachmentIds,
                sessionId: req.cookies['Session_id'],
                trackerTicketType: 'task',
                utils: req.utils,
            })
                .then(({id}) => res.status(200).send({id}))
                .catch((err) => {
                    req.ctx.logError('FAILED CREATE SUPPORT TICKET', err);
                    return res.status(500).send(err);
                });
        }
        case 'upload-file': {
            return uploadTrackerFileInternal({
                utils: req.utils,
                formData: req.body,
                headers: req.headers,
                sessionId: req.cookies['Session_id'],
            })
                .then((data) => res.status(200).send(data))
                .catch((err) => {
                    req.ctx.logError('FAILED UPLOAD TRACKER FILE', err);
                    console.trace(err);
                    return res.status(500).send(err);
                });
        }
        default:
            return res.status(404).send({
                status: 404,
                code: 'UNKNOWN_ACTION',
                message: 'Unknown action',
            });
    }
}
