import {NextFunction, Request, Response} from '@yandex-data-ui/core/build/types';

export default async function (req: Request, res: Response, next: NextFunction) {
    const {passportAccounts: accounts} = res.locals;
    const {passport: user} = res.locals;

    res.locals.lang = 'en';
    res.locals.user = {
        yandexuid: req.cookies['yandexuid'],
        accounts: [],
    };

    if (!user || !user.uid) {
        next();
        return
    }

    res.locals.user = Object.assign(res.locals.user, {
        uid: user.uid,
        name: user.displayName,
        login: user.login,
    });

    if (Array.isArray(accounts)) {
        res.locals.user.accounts = accounts.map((account) => ({
            uid: account.uid,
            name: account.displayName,
            login: account.login,
        }));
    }

    return next();
}
