import {CoreRoutes/*, AuthPolicy*/} from '@yandex-data-ui/core/build/types';

const routes: CoreRoutes = {
    'GET /': {
        target: 'user-redirect',
        beforeAuth: ['initial'],
        afterAuth: ['blackbox-user'],
    },
    'GET /ping': {
        target: 'ping',
        beforeAuth: ['initial'],
    },
    'GET /support/telegram': {
        target: 'tg-redirect',
        beforeAuth: ['initial'],
    },
    'POST /support/:action': {
        target: 'support',
        beforeAuth: ['initial'],
    },
    'GET /authorize/:authId/': {
        target: 'authorize',
        beforeAuth: ['initial'],
        afterAuth: ['blackbox-user'],
    },
    'GET /user/:user/*': {
        target: 'main',
        beforeAuth: ['initial'],
        afterAuth: ['blackbox-user'],
    },
}

export default routes;