import {Request, Response} from '@yandex-data-ui/core/build/types';
import _ from 'lodash';

export default function createLayout(name: string, req: Request, res: Response, additionalData?: any) {
    const {
        lang,
        user,
        accounts,
        error,
        avatarHost,
        passportHost,
        csrfToken,
    } = res.locals;

    const data = {
        ...additionalData,
        lang,
        user,
        accounts,
        error,
        avatarHost,
        passportHost,
        csrfToken,
    };

    return res.renderLayout2({
        name,
        data,
        lang,
        title: 'Skotty',
        inlineScripts: ['window.SK = window.__DATA__;'],
        meta: {
            google: 'notranslate',
        }
    });
}
