import React from "react";
import './BigError.scss';
import cn from 'bem-cn-lite';
import {Card} from '@yandex-data-ui/common';

const b = cn('big_error');

interface MainErrorProps {
  msg: string;
}

export function BigError(props: React.PropsWithChildren<MainErrorProps>) {
    return (
      <div className={b()}>
        <Card className={b('content')} theme="danger" type="container" view="filled">
            <p className={b('header')}>Ooops</p>
            <div className={b('body')}>{props.msg}</div>
        </Card>
      </div>
    );
}
