import React from 'react';
import {Label} from '@yandex-data-ui/common';
import {CertState as CS} from '../../models/skotty';

interface CertStateProps {
    state: CS;
    expires: number;
}

export function CertState(props: React.PropsWithChildren<CertStateProps>) {
    const theme = function() {
        if (props.state === CS.Active && (props.expires*1000 - 86400) < Date.now()) {
            return 'danger';
        }

        switch (props.state) {
            case CS.Active:
                return 'info';
            case CS.Renewed:
                return 'unknown';
            case CS.Revoked:
                return 'unknown';
            default:
                return 'unknown'
        }
    }

    const content = () => {
        if (props.state == CS.Active && props.expires*1000 < Date.now()) {
            return 'Expired';
        }

        switch (props.state) {
            case CS.Active:
                return 'Active';
            case CS.Revoked:
                return 'Revoked';
            case CS.Renewed:
                return 'Renewed';
            default:
                return 'N/A'
        }
    }

    return (
        <Label theme={theme()}>
            {content()}
        </Label>
    );
}
