import React from 'react';
import './Header.scss';
import {Header as UIHeader, Icon, Button} from '@yandex-data-ui/common';
import {StandaloneSupportForm, StandaloneSupportFormProps} from '@yandex-data-ui/common';
import {UserAvatar} from '../UserAvatar/UserAvatar';
import {useSupportApi} from '../../services';
import bugIcon from '@yandex-data-ui/common/assets/icons/bug.svg';
import helpIcon from '@yandex-data-ui/common/assets/icons/question.svg';
import telegramIcon from '@yandex-data-ui/fontawesome/svgs/brands/telegram-plane.svg';
import Logo from '../../assets/logo.svg';

export function Header() {
    const user = window.SK.user || {};

    const skottyApi = useSupportApi();
    const onBugSend: StandaloneSupportFormProps['onSend'] = React.useCallback(
        async ({files, screenshot, message: description, topic: summary}) => {
            try {
                let attachmentIds: string[] = [];
                if (files.length || screenshot) {
                    const promises = ([...files, screenshot].filter(Boolean) as File[]).map(
                        (file: File) => {
                            const formData = new FormData();
                            formData.append('file', file);
                            formData.append('filename', file.name);

                            return skottyApi.uploadFile(formData);
                        },
                    );

                    attachmentIds = await Promise.all(promises);
                }

                const {id: tiketId, link} = await skottyApi.createTicket({
                    summary,
                    description,
                    attachmentIds,
                    meta: {
                        URL: location.href,
                        userAgent: navigator.userAgent,
                    },
                });

                return {
                    status: 'success',
                    ticketData: {
                        ticketName: tiketId,
                        ticketUrl: link,
                    },
                };
            } catch (error) {
                return {
                    status: 'error',
                    error,
                };
            }
        },
        [],
    );

    const bugHandler = React.useCallback(() => {
        StandaloneSupportForm.create({
            caption: 'Bug report',
            installationType: 'internal',
            screenshotCaptureMode: 'viewport',
            onSend: onBugSend,
        });
    }, [onBugSend]);

    return (
        <UIHeader
            logoText="Skotty"
            logoIcon={(<Icon data={Logo} size="36px" />)}
            children={(
                <div className={"support-links"}>
                    <Button size="m" type="button" view="flat" href="https://oauth.yandex-team.ru/authorize?response_type=token&amp;client_id=80a656c7a6de46d5af611bceb536bb0f" target="_blank" style={{marginRight: '10px'}}>
                        OAuth
                    </Button>
                    <Button size="m" type="button" view="flat" onClick={bugHandler} style={{marginRight: '10px'}}>
                        <Icon data={bugIcon}/>
                    </Button>
                    <Button size="m" type="button" view="flat" href="/support/telegram" target="_blank" style={{marginRight: '10px'}}>
                        <Icon data={telegramIcon}/>
                    </Button>
                    <Button size="m" type="button" view="flat" href="https://docs.yandex-team.ru/skotty/" target="_blank">
                        <Icon data={helpIcon}/>
                    </Button>
                </div>
            )}
            customUserAvatar={(
                <UserAvatar
                    uid={user.uid}
                    yu={user.yandexuid}
                    login={user.login}
                    name={user.name}
                    accounts={user.accounts}
                />
            )}
            actionsMenu={[]}
            hasMenu={false}
            userInternal
        />
    );
}
