import React, {/*useRef,*/ useState, useEffect} from "react";
import './Main.scss';
import {Copyright, Footer} from "lego-on-react";
import {RouteComponentProps} from 'react-router-dom';
import {Loader} from '@yandex-data-ui/common';
import {Header} from '../Header/Header';
import {TokenList} from '../TokenList/TokenList';
import {TokenView} from '../TokenView/TokenView';
import {NoTokens} from '../NoTokens/NoTokens';
import {BigError} from '../BigError/BigError';
import {useSkottyApi} from "../../services";
import {Token} from "../../models/skotty";

let tokenId: string;
let enrollId: string;

interface MainProps extends RouteComponentProps {}

export default function Main({ history, match }: MainProps) {
    const skottyApi = useSkottyApi();
    const [errorMsg, setErrorMsg] = useState("");
    const [tokens, setTokens] = useState<Token[]>([]);
    const [loading, setLoading] = useState(true);
    const [token, setToken] = useState<Token | undefined>(undefined);

    (() => {
        if (!('0' in match.params) || tokenId || enrollId) {
            return;
        }

        const pathParams = (match.params as {[index: string]:string})['0'].split('/');
        if (pathParams.length >= 2) {
            tokenId = pathParams[0];
            enrollId = pathParams[1];
        }
    })();

    useEffect(() => {
        skottyApi
            .listTokens(window.SK.tokenUser)
            .then(r => {
                if (!!r.errorCode) {
                    setErrorMsg(r.errorMsg);
                    return;
                }

                setLoading(false);
                setTokens(r);
                
                if (!tokenId && r.length == 1) {
                    setToken(r[0]);
                }
                
                if (!!tokenId && !!enrollId) {
                    for (let t of r) {
                        if (tokenId != t.id || enrollId != t.enrollId) {
                            continue;
                        }

                        setToken(t);
                    }
                }
            })
            .catch(error => {
                setErrorMsg(`fetch failed: ${error.message}`);
            });
    }, [skottyApi, tokenId, enrollId]);

    useEffect(() => {
        if (!token) {
            return;
        }

        history.replace(`/user/${window.SK.tokenUser}/${token.id}/${token.enrollId}`);
    }, [token])

    return (
        <React.Fragment>
            <header><Header /></header>
            <main className="main_body">
            {
                (errorMsg && <BigError msg={errorMsg}/>) ||
                (loading && <Loader size="l"/>) ||
                (tokens.length == 0 && <NoTokens/>) || (
                    <React.Fragment>
                        <TokenList loading={loading} tokens={tokens} token={token} onSelectToken={setToken} />
                        <TokenView loading={loading} token={token} />
                    </React.Fragment>
                )
            }
            </main>
            <footer>
                <Footer region="en" tld="en">
                    <Footer.Column side="right">
                        <Footer.Link theme={"normal"} url="https://wiki.yandex-team.ru/nda/" target="_blank">
                            NDA
                        </Footer.Link>
                        <Copyright start={2021}>LLC «Yandex»</Copyright>
                    </Footer.Column>
                </Footer>
            </footer>
        </React.Fragment>
    );
}
