import React, {useState} from "react";
import {Button, Dialog} from '@yandex-data-ui/common';

interface RevokeButtonProps {
    tokenName: string;
    loading?: boolean;
    disabled?: boolean;
    onConfirm: () => void;
}

export function RevokeButton(props: React.PropsWithChildren<RevokeButtonProps>) {
    const [open, setOpen] = useState<boolean>();

    return <>
        <Button view="outlined-danger" size="m" disabled={props.disabled} loading={props.loading} onClick={() => setOpen(true)} >Revoke</Button>
        <Dialog
            open={open || false}
            onClose={() => setOpen(false)}
            size="m"
        >
            <Dialog.Header caption="Token revocation" />
            <Dialog.Body>
                Caution! You are about to revoke a token: <b>{props.tokenName}</b>.
            </Dialog.Body>
            <Dialog.Footer
            onClickButtonApply={() => {props.onConfirm(); setOpen(false);}}
            onClickButtonCancel={() => setOpen(false)}
            textButtonApply="Confirm"
            textButtonCancel="Cancel"
            propsButtonApply={
                {
                    view: "outlined-danger"
                }
            }
            />
        </Dialog>
    </>
}
