import React from 'react';
import {TokenState as ETS, TokenType as ETT} from '../../models/skotty';
import faHatSanta from '@yandex-data-ui/fontawesome/svgs/solid/hat-santa.svg';
import faMemory from '@yandex-data-ui/fontawesome/svgs/solid/memory.svg';
import faSave from '@yandex-data-ui/fontawesome/svgs/solid/save.svg';
import faUsbDrive from '@yandex-data-ui/fontawesome/svgs/solid/usb-drive.svg';
import {Label, Icon} from '@yandex-data-ui/common';

interface TokenStateProps {
    type: ETT;
    state: ETS;
    expires: number;
}

export function TokenIcon(props: React.PropsWithChildren<TokenStateProps>) {
    const icon = function () {
        switch (props.type) {
            case ETT.Yubikey:
                return <Icon data={faUsbDrive} size={16}/>
            case ETT.Soft:
                return <Icon data={faSave} size={16}/>
            case ETT.Memory:
                return <Icon data={faMemory} size={16}/>
            default:
                return <Icon data={faHatSanta} size={16}/>
        }
    }

    const dangerTTL = function () {
        switch (props.type) {
            case ETT.Memory:
                return 3600
            default:
                return 86400
        }
    }

    const theme = function () {
        if (props.state != ETS.Revoked && (props.expires * 1000 - dangerTTL()) < Date.now()) {
            return 'danger';
        }

        switch (props.state) {
            case ETS.Active:
                return 'info';
            case ETS.Revoking:
                return 'warning';
            default:
                return 'unknown'
        }
    }

    return (
        <Label theme={theme()}>
            {icon()}
        </Label>
    )
}
