import React from "react";
import './TokenList.scss';
import cn from 'bem-cn-lite';
import {Menu, Loader} from '@yandex-data-ui/common';
import {Token} from '../../models/skotty';
import {TokenIcon} from '../TokenIcon/TokenIcon';

const b = cn('token_list');

interface TokenListProps {
    className?: string;
    tokens: Token[];
    token: Token | undefined;
    loading: boolean;
    onSelectToken: (token: Token) => void;
}

export function TokenList(props: React.PropsWithChildren<TokenListProps>) {
    return (
        <div className={b()}>
             <div className={b('title')}>Available tokens</div>
             <Menu className={b('menu', props.className)} size="l">
                {(props.loading && <div className={b('loader')}><Loader size="m" /></div>) || ( 
                props.tokens.map(token => (
                    <Menu.Item
                        key={token.id+token.enrollId}
                        onClick={() => props.onSelectToken(token)}
                        active={props.token && token.id == props.token.id && token.enrollId == props.token.enrollId}
                    >
                        <div>
                            <div className={b('token_title')}>
                                <div><TokenIcon type={token.tokenType} state={token.tokenState} expires={token.expiresAt} /></div>
                                <div>{token.name || `#${token.id}`}</div>
                            </div>
                        </div>
                    </Menu.Item>
                )))}
            </Menu>
        </div>
    );
}
