import React from 'react';
import {Label} from '@yandex-data-ui/common';
import {TokenState as ETS} from '../../models/skotty';

interface TokenStateProps {
    state: ETS;
    expires: number;
}

export function TokenState(props: React.PropsWithChildren<TokenStateProps>) {
    const theme = function() {
        if (props.state != ETS.Revoked && (props.expires*1000 - 86400) < Date.now()) {
            return 'danger';
        }

        switch (props.state) {
            case ETS.Active:
                return 'info';
            case ETS.Revoking:
                return 'warning';
            default:
                return 'unknown'
        }
    }

    const content = () => {
        if (props.state == ETS.Active && props.expires*1000 < Date.now()) {
            return 'Expired';
        }

        switch (props.state) {
            case ETS.Active:
                return 'Active';
            case ETS.Revoking:
                return 'Revoking';
            case ETS.Revoked:
                return 'Revoked';
            default:
                return 'N/A'
        }
    }

    return (
        <Label theme={theme()}>
            &nbsp;{content()}
        </Label>
    );
}
