import React from 'react';
import block from 'bem-cn-lite';
import { User, UserAccount } from 'lego-on-react';

const b = block('yc-header');

interface UserAccountProps {
	uid: string,
    name: string,
    login: string,
}

interface UserAvatarProps {
    uid: string,
    yu: string,
    login: string,
    name: string,
    accounts?: UserAccountProps[],
}

export function UserAvatar(props: React.PropsWithChildren<UserAvatarProps>) {
    return (
        <div className={b('user-account')}>
        	<User
        		uid={props.uid}
        		yu={props.yu}
        		avatarId={props.login}
        		name={props.name}
        		provider={'yandex-team'}
        		helpUrl={'https://wiki.yandex-team.ru/security/skotty'}
        		settingsUrl={'https://staff.yandex-team.ru/settings'}
        		passportHost={'https://passport.yandex-team.ru'}
        		actionsMenu={[]}
        		retpath={`${window.location.protocol}//${window.location.host}`}
        	>
    		    {props.accounts?.
    		    	filter(({ uid }) => uid !== props.uid).
    		    	map(function(account) {
			        	return <UserAccount
			        		key={account.uid}
			        		uid={account.uid}
			        		name={account.name}
			        		avatarId={account.login}
			        		pic={true}
			        	/>;
			    	})
    		   	}
        	</User>
        </div>
    );
}
