import React from 'react';
import ReactDOM from 'react-dom';
import {ThemeProvider} from '@yandex-data-ui/common';
import {I18N} from '@yandex-data-ui/i18n';
import '@yandex-data-ui/common/styles/styles.scss';
import Authorize from '../components/Authorize/Authorize';
import {ApiServices, ApiServicesContext} from '../services';

const apiServices = new ApiServices();

I18N.setDefaultLang('en');
ReactDOM.render((
    <ApiServicesContext.Provider value={apiServices}>
        <ThemeProvider theme="light">
            <Authorize/>
        </ThemeProvider>
    </ApiServicesContext.Provider>
), document.getElementById('root'));
