import React from 'react';
import ReactDOM from 'react-dom';
import {ThemeProvider} from '@yandex-data-ui/common';
import {I18N} from '@yandex-data-ui/i18n';
import '@yandex-data-ui/common/styles/styles.scss';
import Main from '../components/Main/Main';
import {ApiServices, ApiServicesContext} from '../services';
import { BrowserRouter, Route } from "react-router-dom";

const apiServices = new ApiServices();

I18N.setDefaultLang('en');
ReactDOM.render((
    <ApiServicesContext.Provider value={apiServices}>
        <ThemeProvider theme="light">
            <BrowserRouter>
                <Route path="/user/:login/*" component={Main}/>
            </BrowserRouter>
        </ThemeProvider>
    </ApiServicesContext.Provider>
), document.getElementById('root'));
