export enum CertType {
    None = 'none',
    Secure = 'secure',
    Insecure = 'insecure',
    Sudo = 'sudo',
    Legacy = 'legacy',
    Renew = 'renew',
}

export enum TokenType {
    None = 'none',
    Yubikey = 'yubikey',
    Soft = 'soft',
    Memory = 'memory',
}

export enum TokenState {
    None = 'none',
    Active = 'active',
    Revoked = 'revoked',
    Revoking = 'revoking',
}

export enum CertState {
    None = 'none',
    Active = 'active',
    Revoked = 'revoked',
    Renewed = 'renewed',
}

export type Token = {
    id: string;
    user: string;
    enrollId: string;
    name: string;
    tokenType: TokenType;
    tokenState: TokenState;
    createdAt: number;
    updatedAt: number;
    expiresAt: number;
}

export type Certificate = {
    serial: string;
    certType: CertType;
    certState: CertState;
    fingerprint: string;
    principal: string;
    createdAt: number;
    validAfter: number;
    validBefore: number;
}

export type AuditMsg = {
    ts: number;
    message: string;
}

export enum AuthKind {
    Enroll = 'enroll_user',
    Renew = 'renew_user',
}

export type AuthInfo = {
    authKind: AuthKind;
    tokenId: string;
    tokenType: string;
    tokenName: string;
    enrollId: string;
    hostname: string;
    phone: string;
}
