import {CancelToken, AxiosResponse, AxiosError} from 'axios';
import _ from 'lodash';
import {RequestService, RequestConfig, ServiceError} from './request-service';

type SupportTicketReq = {
    attachmentIds: string[];
    description: string;
    summary: string;
    meta: Record<string, unknown>;
};

export class SupportApi extends RequestService {
    request<R = unknown>(
        {method = 'GET', url, data}: RequestConfig,
        cancelToken?: CancelToken,
    ) {

        return this.axios
            .request({
                method: method,
                url: `/support/${url}`,
                data,
                cancelToken,
            })
            .then((response: AxiosResponse<R & ServiceError>) => response.data)
            .catch((error: AxiosError) => {
                if (this.isCancel(error)) {
                    console.info('[skotty] Request canceled');
                }

                throw error;
            });
    }

    createTicket(req: SupportTicketReq): Promise<{id: string, link: string}> {
        return this.request<{id: string}>({
            method: 'post',
            url: `create-ticket`,
            data: req,
        }).then((data: {id: string}) => ({id: data.id, link: `https://st.yandex-team.ru/${data.id}`}));
    }

    uploadFile(req: FormData): Promise<string> {
        return this.request<{id: string}>({
            method: 'post',
            url: `upload-file`,
            data: req,
        }).then((data: {id:string}) => data.id);
    }
}
