import React, {useContext} from "react";
import {SkottyApi} from "./SkottyApi";
import { SupportApi } from "./SupportApi";


export class ApiServices {
    public skotty: SkottyApi;
    public support: SupportApi;

    constructor() {
        this.skotty = new SkottyApi();
        this.support = new SupportApi();
    }
}

export const ApiServicesContext = React.createContext<ApiServices | null>(null);

export function useSkottyApi() {
    const api = useContext(ApiServicesContext);
    if (api === null) {
        throw new Error("you must define value for ApiServicesContext");
    }

    return api.skotty;
}

export function useSupportApi() {
    const api = useContext(ApiServicesContext);
    if (api === null) {
        throw new Error("you must define value for ApiServicesContext");
    }

    return api.support;
}