import axios, {AxiosInstance/*, AxiosError*/, CancelToken, Canceler, Method, AxiosRequestConfig} from 'axios';

export type ServiceError = {
    errorCode: number;
    errorMsg: string;
}

export interface RequestConfig {
    method?: Method;
    url: string;
    data?: any;
}

const defaultAxiosConfig = {
    withCredentials: true,
    xsrfCookieName: '',
}

const NULL_HEADER = '__null__';

export abstract class RequestService {
    axios: AxiosInstance;

    constructor(config = defaultAxiosConfig) {
        this.axios = axios.create(config);
        this.axios .interceptors.request.use((config: AxiosRequestConfig) => {
            if (!config.headers) {
                config.headers = {};
            }

            // https://github.com/axios/axios/issues/382
            // иначе нельзя сбросить дефолтный хедер инстанса
            if (config.headers['X-CSRF-Token'] === NULL_HEADER) {
                delete config.headers['X-CSRF-Token'];
            } else if (window.SK.csrfToken) {
                config.headers['X-CSRF-Token'] = window.SK.csrfToken;
            }
            return config;
        });
    }

    createCancelSource() {
        return axios.CancelToken.source();
    }

    createCancelToken(cancel: () => Canceler) {
        return new axios.CancelToken(cancel);
    }

    isCancel(value: any) {
        return axios.isCancel(value);
    }

    abstract request<R>(
        config: RequestConfig,
        cancelToken?: CancelToken,
    ): Promise<R & ServiceError>;
}
