package common

import (
	"context"
	"fmt"
	"net/http"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/security/skotty/service/internal/app/controller"
	"a.yandex-team.ru/security/skotty/service/internal/app/env"
)

type Controller struct {
	*env.Env
}

func NewController(e *env.Env) (controller.Controller, error) {
	return &Controller{
		Env: e,
	}, nil
}

func (c *Controller) BuildRoute(r chi.Router) {
	r.Get("/readiness", func(w http.ResponseWriter, _ *http.Request) {
		// TODO(buglloc): check db state
		_, _ = w.Write([]byte{'O', 'K'})
	})

	r.Get("/liveness", func(w http.ResponseWriter, _ *http.Request) {
		_, _ = w.Write([]byte{'O', 'K'})
	})

	r.Get("/roles", func(w http.ResponseWriter, r *http.Request) {
		roles, err := c.TVM.GetRoles(r.Context())
		if err != nil {
			http.Error(w, fmt.Sprintf("unable to get TVM roles: %v", err), http.StatusInternalServerError)
		}

		meta := roles.GetMeta()
		_, _ = fmt.Fprintf(w, "Revision: %s\nBorn time: %s\nApplied at: %s\n", meta.Revision, meta.BornTime, meta.Applied)
	})
}

func (c *Controller) Shutdown(_ context.Context) {}
