package frontapi

import "a.yandex-team.ru/security/skotty/service/internal/models"

type ErrorRsp struct {
	Code int    `json:"errorCode"`
	Msg  string `json:"errorMsg"`
}

type AuthInfoReq struct {
	AuthToken string `json:"authToken"`
}

type AuthInfoRsp struct {
	AuthKind  models.AuthKind  `json:"authKind"`
	TokenID   string           `json:"tokenId"`
	TokenType models.TokenType `json:"tokenType"`
	TokenName string           `json:"tokenName"`
	EnrollID  string           `json:"enrollId"`
	HostName  string           `json:"hostname"`
	Phone     string           `json:"phone"`
}

type SendCodeReq struct {
	AuthToken string `json:"authToken"`
}

type AuthApproveReq struct {
	AuthToken string `json:"authToken"`
	MFACode   uint32 `json:"mfaCode"`
}

type Token struct {
	ID         string            `json:"id"`
	User       string            `json:"user"`
	EnrollID   string            `json:"enrollId"`
	Name       string            `json:"name"`
	TokenType  models.TokenType  `json:"tokenType"`
	TokenState models.TokenState `json:"tokenState"`
	CreatedAt  int64             `json:"createdAt"`
	UpdatedAt  int64             `json:"updatedAt"`
	ExpiresAt  int64             `json:"expiresAt"`
}

type Cert struct {
	Serial        string           `json:"serial"`
	CertType      models.CertType  `json:"certType"`
	CertState     models.CertState `json:"certState"`
	CAFingerprint string           `json:"caFingerprint"`
	Fingerprint   string           `json:"fingerprint"`
	Principal     string           `json:"principal"`
	CreatedAt     int64            `json:"createdAt"`
	ValidAfter    int64            `json:"validAfter"`
	ValidBefore   int64            `json:"validBefore"`
}

type AuditMsg struct {
	TS      int64  `json:"ts"`
	Message string `json:"message"`
}
