package hostapi

import (
	"crypto/subtle"
	"encoding/json"
	"fmt"
	"net/http"

	"a.yandex-team.ru/security/skotty/libs/skotty"
)

func hostCheckAuthMiddleware(next http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		key := r.Header.Get(skotty.SnakeTokenHeader)
		if subtle.ConstantTimeCompare([]byte(key), []byte(skotty.SnakeToken)) != 1 {
			err := &skotty.ServiceError{
				Code: skotty.ServiceErrorInvalidRequest,
				Msg:  fmt.Sprintf("invalid %s value", skotty.SnakeTokenHeader),
			}

			w.Header().Set("Content-Type", "application/json; charset=utf-8")
			w.WriteHeader(http.StatusBadRequest)
			_ = json.NewEncoder(w).Encode(err)
			return
		}

		next.ServeHTTP(w, r)
	})
}
