package hostapi

import (
	"a.yandex-team.ru/security/skotty/libs/skotty"
	"a.yandex-team.ru/security/skotty/service/internal/models"
)

type CertsReq struct {
	TokenType       skotty.TokenType
	AttestationCert []byte
	Certificates    []skotty.RequestedCertificate
}

type CertsRsp struct {
	AuthID       string
	User         string
	UserTicket   string
	TokenSerial  string
	TokenID      string
	TokenName    string
	TokenType    skotty.TokenType
	EnrollmentID string
	ExpiresAt    int64
	Certificates []skotty.IssuedCertificate
}

type RenewInfo struct {
	User         string
	TokenSerial  string
	TokenType    models.TokenType
	EnrollmentID string
}
