package commands

import (
	"context"
	"errors"
	"fmt"
	"time"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/skotty/service/internal/app/env"
	"a.yandex-team.ru/security/skotty/service/internal/config"
	"a.yandex-team.ru/security/skotty/service/internal/revoker"
)

var krlArgs struct {
	Configs     []string
	DriftPeriod time.Duration
}

var krlCmd = &cobra.Command{
	Use:          "krl",
	SilenceUsage: true,
	Short:        "krl commands",
	PersistentPreRunE: func(_ *cobra.Command, _ []string) error {
		if len(krlArgs.Configs) == 0 {
			return errors.New("--config is empty")
		}

		return nil
	},
}

var createCmd = &cobra.Command{
	Use:          "create",
	SilenceUsage: true,
	Short:        "gen&&upload new KRL",
	RunE: func(cmd *cobra.Command, args []string) error {
		cfg, err := config.Load(krlArgs.Configs...)
		if err != nil {
			return fmt.Errorf("failed to parse config: %w", err)
		}

		appEnv := env.NewEnv(cfg)
		if err := appEnv.Initialize(); err != nil {
			return fmt.Errorf("failed to initialize app env: %w", err)
		}

		defer func() { _ = appEnv.Shutdown(context.Background()) }()

		return appEnv.Revoker.Process(krlArgs.DriftPeriod)
	},
}

func init() {
	flags := krlCmd.PersistentFlags()
	flags.StringSliceVarP(&krlArgs.Configs, "config", "c", nil, "config path")
	flags.DurationVarP(&krlArgs.DriftPeriod, "drift", "d", revoker.DriftPeriod, "drift period")

	krlCmd.AddCommand(createCmd)
}
