package logger

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

var l = func() log.Logger {
	zlog, err := zap.NewDeployLogger(log.InfoLevel)
	if err != nil {
		panic(err)
	}

	return zlog
}()

func Named(name string) log.Logger {
	return l.WithName(name)
}

func Debug(msg string, fields ...log.Field) {
	l.Debug(msg, fields...)
}

func Info(msg string, fields ...log.Field) {
	l.Info(msg, fields...)
}

func Warn(msg string, fields ...log.Field) {
	l.Warn(msg, fields...)
}

func Error(msg string, fields ...log.Field) {
	l.Error(msg, fields...)
}

func Fatal(msg string, fields ...log.Field) {
	l.Fatal(msg, fields...)
}

func Structured() log.Structured {
	return l.Structured()
}
