package mailer

import (
	"embed"
	"html/template"
	"io"
	"io/fs"
)

//go:embed templates/*.gotmpl
var templatesFS embed.FS

var templates = func() *template.Template {
	templates, err := fs.Sub(templatesFS, "templates")
	if err != nil {
		panic("can't create embed templates fs: " + err.Error())
	}

	return template.Must(
		template.New("").
			ParseFS(templates, "*.gotmpl"),
	)
}()

func renderTemplate(w io.Writer, name string, data interface{}) error {
	return templates.ExecuteTemplate(w, name, data)
}
