package models

import (
	"encoding/json"
	"fmt"
)

var _ json.Marshaler = (*AuthKind)(nil)
var _ json.Unmarshaler = (*AuthKind)(nil)

type AuthKind uint8

const (
	AuthKindNone AuthKind = iota
	AuthKindEnrollHost
	AuthKindEnrollUser
	AuthKindTokenRenew
	AuthKindRenewHost
	AuthKindRenewUser
)

func (a AuthKind) String() string {
	switch a {
	case AuthKindEnrollHost:
		return "enroll_host"
	case AuthKindEnrollUser:
		return "enroll_user"
	case AuthKindTokenRenew:
		return "token_renew"
	case AuthKindRenewHost:
		return "renew_host"
	case AuthKindRenewUser:
		return "renew_user"
	default:
		return fmt.Sprintf("unknown_%d", a)
	}
}

func (a *AuthKind) fromString(s string) error {
	switch s {
	case "enroll_host":
		*a = AuthKindEnrollHost
	case "enroll_user":
		*a = AuthKindEnrollUser
	case "token_renew":
		*a = AuthKindTokenRenew
	case "renew_host":
		*a = AuthKindRenewHost
	case "renew_user":
		*a = AuthKindRenewUser
	case "", "none":
		*a = AuthKindNone
	default:
		return fmt.Errorf("unknown auth kind: %s", s)
	}

	return nil
}

func (a AuthKind) MarshalJSON() ([]byte, error) {
	return json.Marshal(a.String())
}

func (a *AuthKind) UnmarshalJSON(in []byte) error {
	var s string
	if err := json.Unmarshal(in, &s); err != nil {
		return err
	}

	return a.fromString(s)
}
