package models

import (
	"encoding/json"
	"fmt"
)

var _ json.Marshaler = (*TokenType)(nil)
var _ json.Unmarshaler = (*TokenType)(nil)

type CertState uint8

const (
	CertStateNone CertState = iota
	CertStateActive
	CertStateRenewed
	CertStateRevoked
)

func (t CertState) String() string {
	switch t {
	case CertStateActive:
		return "active"
	case CertStateRenewed:
		return "renewed"
	case CertStateRevoked:
		return "revoked"
	case CertStateNone:
		return "none"
	default:
		return fmt.Sprintf("unknown_%d", t)
	}
}

func (t CertState) MarshalJSON() ([]byte, error) {
	return json.Marshal(t.String())
}

func (t *CertState) UnmarshalJSON(in []byte) error {
	var val string
	if err := json.Unmarshal(in, &val); err != nil {
		return err
	}

	switch val {
	case "active":
		*t = CertStateActive
	case "renewed":
		*t = CertStateRenewed
	case "revoked":
		*t = CertStateRevoked
	case "none":
		*t = CertStateNone
	default:
		return fmt.Errorf("unknown cert state: %s", val)
	}

	return nil
}
