package models

import (
	"fmt"

	"a.yandex-team.ru/security/skotty/libs/skotty"
)

type TokenType = skotty.TokenType

const (
	TokenTypeNone    = skotty.TokenTypeNone
	TokenTypeYubikey = skotty.TokenTypeYubikey
	TokenTypeSoft    = skotty.TokenTypeSoft
	TokenTypeMemory  = skotty.TokenTypeMemory
)

type CertType = skotty.CertType

const (
	CertTypeNone     = skotty.CertTypeNone
	CertTypeSudo     = skotty.CertTypeSudo
	CertTypeSecure   = skotty.CertTypeSecure
	CertTypeInsecure = skotty.CertTypeInsecure
	CertTypeLegacy   = skotty.CertTypeLegacy
	CertTypeRenew    = skotty.CertTypeRenew
)

type Authorization struct {
	ID         string
	User       string
	UserTicket string
	Used       bool
	Sign       string
}

type Certificate struct {
	Serial         string
	CAFingerprint  string
	TokenFullID    string
	CertType       CertType
	CertState      CertState
	Principal      string
	TokenType      TokenType
	Cert           []byte
	SSHCert        []byte
	SSHFingerprint string
	CreatedAt      int64
	ValidAfter     int64
	ValidBefore    int64
}

type TokenID struct {
	ID       string
	User     string
	EnrollID string
}

type Token struct {
	ID         string
	User       string
	EnrollID   string
	Name       string
	TokenType  TokenType
	TokenState TokenState
	CreatedAt  int64
	UpdatedAt  int64
	ExpiresAt  int64
}

type MFA struct {
	AuthID      string
	User        string
	RequestedAt uint64
	Code        uint32
	Tries       uint8
}

func TFID(user, tokenID, enrollID string) string {
	return fmt.Sprintf("%s|%s|%s", user, tokenID, enrollID)
}
