package models

import (
	"encoding/json"
	"fmt"
)

var _ json.Marshaler = (*TokenType)(nil)
var _ json.Unmarshaler = (*TokenType)(nil)

type TokenState uint8

const (
	TokenStateNone TokenState = iota
	TokenStateActive
	TokenStateRevoking
	TokenStateRevoked
)

func (t TokenState) String() string {
	switch t {
	case TokenStateActive:
		return "active"
	case TokenStateRevoked:
		return "revoked"
	case TokenStateRevoking:
		return "revoking"
	case TokenStateNone:
		return "none"
	default:
		return fmt.Sprintf("unknown_%d", t)
	}
}

func (t TokenState) MarshalJSON() ([]byte, error) {
	return json.Marshal(t.String())
}

func (t *TokenState) UnmarshalJSON(in []byte) error {
	var val string
	if err := json.Unmarshal(in, &val); err != nil {
		return err
	}

	switch val {
	case "active":
		*t = TokenStateActive
	case "revoked":
		*t = TokenStateRevoked
	case "revoking":
		*t = TokenStateRevoking
	case "none":
		*t = TokenStateNone
	default:
		return fmt.Errorf("unknown token state: %s", val)
	}

	return nil
}
