package reminder

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/libs/go/xlock"
	"a.yandex-team.ru/security/skotty/service/internal/db"
	"a.yandex-team.ru/security/skotty/service/internal/mailer"
)

type Option func(reminder *MailReminder) error

func WithYTLock(proxy, rootPath, token string) Option {
	return func(r *MailReminder) error {
		locker, err := xlock.NewYTLocker(proxy, rootPath+"/reminder", token)
		if err != nil {
			return err
		}

		r.lock = locker
		return nil
	}
}

func WithDB(db *db.DB) Option {
	return func(r *MailReminder) error {
		r.db = db
		return nil
	}
}

func WithLogger(l log.Logger) Option {
	return func(r *MailReminder) error {
		r.log = l.WithName("reminder")
		return nil
	}
}

func WithMailer(m *mailer.Mailer) Option {
	return func(r *MailReminder) error {
		r.mailer = m
		return nil
	}
}
