package revoker

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/libs/go/xlock"
	"a.yandex-team.ru/security/skotty/service/internal/auditlog"
	"a.yandex-team.ru/security/skotty/service/internal/db"
	"a.yandex-team.ru/security/skotty/service/internal/mailer"
	"a.yandex-team.ru/security/skotty/service/internal/signer"
	"a.yandex-team.ru/security/skotty/service/internal/staff"
	"a.yandex-team.ru/security/skotty/service/internal/storage"
)

type Option func(*S3Revoker) error

func WithYTLock(proxy, rootPath, token string) Option {
	return func(r *S3Revoker) error {
		locker, err := xlock.NewYTLocker(proxy, rootPath+"/revoker", token)
		if err != nil {
			return err
		}

		r.lock = locker
		return nil
	}
}

func WithDB(db *db.DB) Option {
	return func(r *S3Revoker) error {
		r.db = db
		return nil
	}
}

func WithLogger(l log.Logger) Option {
	return func(r *S3Revoker) error {
		r.log = l.WithName("revoker")
		return nil
	}
}

func WithS3Store(s *storage.Storage) Option {
	return func(r *S3Revoker) error {
		r.s3Store = s
		return nil
	}
}

func WithCAStore(s *signer.CAStorage) Option {
	return func(r *S3Revoker) error {
		r.caStore = s
		return nil
	}
}

func WithAuditLog(l *auditlog.AuditLog) Option {
	return func(r *S3Revoker) error {
		r.auditLog = l
		return nil
	}
}

func WithMailer(m *mailer.Mailer) Option {
	return func(r *S3Revoker) error {
		r.mailer = m
		return nil
	}
}

func WithStaffClient(staffc *staff.Client) Option {
	return func(r *S3Revoker) error {
		r.staff = staffc
		return nil
	}
}
