package signer

import (
	"crypto/x509"
	"time"

	"a.yandex-team.ru/security/skotty/libs/skotty"
)

type Signer interface {
	CertLifetime() time.Duration
	AttestSlot(certType skotty.CertType, rawAttestationCert, rawSlotCert *x509.Certificate) (*Attestation, error)
	IssueCertificate(certType skotty.CertType, csr *CertificateRequest) (*SSHCert, error)
}

type Attestation struct {
	Serial string
}
