package storage

import "a.yandex-team.ru/library/go/yandex/tvm"

type Option func(*Storage)

func WithBucket(bucket string) Option {
	return func(s *Storage) {
		s.bucket = bucket
	}
}

func WithEndpoint(endpoint string) Option {
	return func(s *Storage) {
		s.endpoint = endpoint
	}
}

func WithAccessKeyID(keyID string) Option {
	return func(s *Storage) {
		s.accessKeyID = keyID
	}
}

func WithTVMClientID(tvmID tvm.ClientID) Option {
	return func(s *Storage) {
		s.tvmID = tvmID
	}
}
