package main

import (
	"fmt"
	"strconv"
	"strings"
	"text/template"

	"a.yandex-team.ru/security/skotty/skotty/internal/assets"
)

var infoPlistTmpl = `
//+build darwin

static const unsigned char info_plist[]
__attribute__ ((section ("__TEXT,__info_plist"),used)) =
{{.Content}};
`

func main() {
	var content strings.Builder
	plist := assets.InfoPlist()
	if len(plist) == 0 {
		panic("no Info.plist available")
	}

	for _, l := range strings.Split(plist, "\n") {
		l = strings.TrimSpace(l)
		if l == "" {
			continue
		}

		content.WriteString(strconv.Quote(l + "\n"))
		content.WriteByte('\n')
	}

	data := struct {
		Content string
	}{
		Content: content.String(),
	}

	var out strings.Builder
	err := template.Must(template.New("tmpl").Parse(infoPlistTmpl)).Execute(&out, data)
	if err != nil {
		panic(fmt.Sprintf("can't render template: %v", err))
	}

	fmt.Println(out.String())
}
