package main

import (
	"fmt"
	"os"
	"runtime"

	"a.yandex-team.ru/security/skotty/skotty/internal/commands"
	"a.yandex-team.ru/security/skotty/skotty/pkg/osutil"
)

func fatal(err error) {
	_, _ = fmt.Fprintf(os.Stderr, "skotty: %v\n", err)
	os.Exit(1)
}

func main() {
	runtime.GOMAXPROCS(1)

	if err := osutil.SetNoDumpable(); err != nil {
		fatal(err)
	}

	if err := osutil.DisableCoreDumps(); err != nil {
		fatal(err)
	}

	if err := commands.Execute(); err != nil {
		fatal(err)
	}
}
