package main

import (
	"fmt"
	"os"
	"os/exec"
)

func fatalf(msg string, a ...interface{}) {
	_, _ = fmt.Fprintf(os.Stderr, "unpacker: "+msg+"\n", a...)
	os.Exit(1)
}

func main() {
	selfExe, err := os.Executable()
	if err != nil {
		fatalf("failed to determine self executable path: %w", err)
	}

	if err := Unpack(selfExe); err != nil {
		fatalf("unable to unpack: %v", err)
	}

	cmd := exec.Command(selfExe, os.Args[1:]...)
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr
	cmd.Stdin = os.Stdin
	if err := cmd.Run(); err != nil {
		fatalf("child exec fail: %w", err)
	}
}
