package main

import (
	"errors"
	"os"
	"path/filepath"

	"a.yandex-team.ru/security/libs/go/sfx"
)

func Unpack(selfExe string) error {
	if !sfx.IsZip(selfExe) {
		return errors.New("not a archive")
	}

	dst := filepath.Dir(selfExe)
	if err := sfx.Unzip(selfExe, filepath.Join(dst, "Skotty.app")); err != nil {
		return err
	}

	if err := os.Rename(selfExe, selfExe+".old"); err != nil {
		return err
	}

	targetExe := filepath.Join(dst, "Skotty.app", "Contents", "MacOS", "skotty")
	return os.Symlink(targetExe, selfExe)
}
