package agent

import (
	"fmt"

	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"

	"a.yandex-team.ru/library/go/core/log"
	xzap "a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/security/libs/go/xlog"
)

func NewAgentLogger(outPath, lvl string) (log.Logger, error) {
	logLevel, err := log.ParseLevel(lvl)
	if err != nil {
		return nil, fmt.Errorf("invalid log level: %w", err)
	}

	if err := xlog.RegisterXRotateSink(); err != nil {
		return nil, fmt.Errorf("failed to register xrotate logs skink: %w", err)
	}

	return xzap.New(zap.Config{
		Level:       zap.NewAtomicLevelAt(xzap.ZapifyLevel(logLevel)),
		Development: false,
		Encoding:    "json",
		EncoderConfig: zapcore.EncoderConfig{
			TimeKey:        "ts",
			LevelKey:       "level",
			NameKey:        "logger",
			MessageKey:     "msg",
			CallerKey:      zapcore.OmitKey,
			FunctionKey:    zapcore.OmitKey,
			StacktraceKey:  zapcore.OmitKey,
			LineEnding:     zapcore.DefaultLineEnding,
			EncodeLevel:    zapcore.LowercaseLevelEncoder,
			EncodeTime:     zapcore.ISO8601TimeEncoder,
			EncodeDuration: zapcore.SecondsDurationEncoder,
		},
		OutputPaths: []string{
			xlog.LogURL(outPath),
		},
		ErrorOutputPaths: []string{"stderr"},
	})
}
